#include "ScreenQuadPS_Rm.hlsl"
struct Section
{
float End;
float Radius;
};


float columns(in float3 p)
{
    const int sectionCount = 5;
    const float cFactor = 2 * 0.03225;
    const Section columnProfile[] =
    {
        {10, 15 },
        {30, 12 },
        {35, 15 },
        {140,10 },
        {155,20 }
    };

    float r = 0;
    float min = 0;
    float max = 1;
    float dist = 1e10;
    float3 cylinderBase = float3(0,0,0);
    
    const float warpRadius    = 200 * cFactor;
    float3 warpVector   = float3(5,0,5); //warpRadius, 0, warpRadius);
    float3 warped = warpBox( p, cylinderBase, warpVector );

    [unroll]
    for(int i = 0; i < sectionCount; i++)
    {
        Section sec = columnProfile[i];
        max =   cFactor*sec.End;
        r = cFactor * sec.Radius;
        dist = _union( dist, yCutCylinder(warped - WorldAxis.Y * min, r, max - min) );
        min = max;
    }
    return dist;
}

float arche2(in float3 p)
{
    const float3 bb = (float3)4.0;
    float d = sdCylinder(p.yzx + bb * WorldAxis.Z, bb);
    //float d = sdCylinder(p.zxy + bb * WorldAxis.X, bb);
    d = _union(d, sdCylinder(p.zxy + bb * WorldAxis.X, bb));
    d = difference(udRoundBox(p - (2*bb+1 )*WorldAxis.Y, 1.25*bb, 0.01), d);

    return d;
}

static const float scaleFactor = 1.5;

float scene_old(in float3 p)
{
    float d = 1e10;
    p /=scaleFactor;
    d = _union(d, plane(p,  WorldAxis.Y,  WorldPoints.O));
    d = _union(d,columns(p));
   
    const float3 c = float3(10, 100, 10);
    float3 q = fmod(abs(p),c) - (0.5*c)* float3(1,0,1);
    d = _union(d, arche2(q - 6 *  WorldAxis.Y));
   
   return d*=scaleFactor;
}


static const float introSup = 0.15;

float domainMax()
{
    return LedCubeSide + floor(smoothstep(0, introSup, SequenceRatio) *  LedCubeSideMinusOne); 
}

float4 main( PS_INPUT input) : SV_Target
{
    class ChurchDomain : LedDomain 
    { 
       bool IsOutside(in float3 p)
        {
            return any(p > domainMax() ) || any(p < 0 );
        }
    } churchDomain;


    class Churchscene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            //p.x += 5;
             // fade in
            if(SequenceRatio < introSup)
            {
                float smooth = smoothstep(0, introSup, SequenceRatio); //(0 to 1)
                //p.y += HalfLedCubeSide *(1 -smoothstep(0, 0.1, SequenceRatio));
                
                return (-1 + smooth) + smooth* (1-scene_old(p)) ;
            }

            if(SequenceRatio < 0.9)
            {
                float smooth = smoothstep(introSup, 0.9, SequenceRatio);
                float t = smooth*2*Pi;
                float3 c = float3(LedCubeSide, 0, LedCubeSide);
                //p =  rotateY(p -c , t) + c;
                return 1 - scene_old(p + smooth*100*WorldAxis.Z);
            }// );

            // fade out to 1
            float smooth = 1-smoothstep(0.9, 1., SequenceRatio); //(from 1 to 0)

            return (-1 * (1- smooth)) + smooth* (1-scene_old(p + 100*WorldAxis.Z));
        }
    } churchScene;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
            // UV --> input.Text.xy e [0 1]
            /*
            o---------X
            |
            |
            |
            |
            Y
            */

                      // Pixel position return 1 - scene_old(p/1.5 + SequenceRatio*100*WorldAxis.X)*1.5;
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation
                //Let's move in view space, right handed (to fiz cross product errors

            float3 rayOrigin    = float3(HalfLedCubeSide,HalfLedCubeSide, 2*LedCubeSide);
            rayOrigin += smoothstep(0, introSup, SequenceRatio)* float3(HalfLedCubeSide,0., LedCubeSide);
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -2));
    
            float t = smoothstep(0, introSup, SequenceRatio)* 0.18;
            rayDirection =  rotateX(rayDirection, t);

            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, churchScene, churchDomain);
}